<?php if (isset($component)) { $__componentOriginal66d7cfd03cd343304d81fe1e21646540 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal66d7cfd03cd343304d81fe1e21646540 = $attributes; } ?>
<?php $component = App\View\Components\MainLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('main-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\MainLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <!-- Hero Section -->
    <div class="relative bg-slate-900 py-24 sm:py-32">
        <div class="absolute inset-0 overflow-hidden">
            <img src="https://images.unsplash.com/photo-1517245386807-bb43f82c33c4?q=80&w=2940&auto=format&fit=crop"
                alt="Conferences Background" class="w-full h-full object-cover opacity-20">
            <div class="absolute inset-0 bg-gradient-to-t from-slate-900 via-slate-900/50"></div>
        </div>

        <div class="relative max-w-7xl mx-auto px-6 lg:px-8 text-center">
            <h1 class="text-4xl font-bold tracking-tight text-white sm:text-6xl mb-6 font-outfit">
                Upcoming Conferences <span class="text-brand-500">2026-2027</span>
            </h1>
            <p class="mt-6 text-lg leading-8 text-gray-300 max-w-2xl mx-auto">
                Discover global opportunities to network, share research, and shape the future. Join thousands of
                academics and professionals at our premier events.
            </p>

            <!-- Search/Filter Bar -->
            <div class="mt-10 max-w-4xl mx-auto">
                <form action="<?php echo e(route('upcoming-conferences')); ?>" method="GET"
                    class="bg-white rounded-3xl shadow-xl p-3 sm:p-4">
                    <div class="flex flex-col sm:flex-row gap-4">
                        <!-- Search Input -->
                        <div class="relative flex-grow group">
                            <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                <i
                                    class="fas fa-search text-gray-400 group-focus-within:text-brand-500 transition-colors"></i>
                            </div>
                            <input type="text" name="search" value="<?php echo e(request('search')); ?>"
                                placeholder="Search by topic, city..."
                                class="block w-full pl-11 pr-4 py-3 border-gray-200 rounded-xl text-gray-900 placeholder-gray-400 focus:ring-2 focus:ring-brand-500 focus:border-transparent transition-shadow bg-gray-50 focus:bg-white">
                        </div>

                        <!-- Year Filter -->
                        <div class="min-w-[140px]">
                            <select name="year"
                                class="block w-full py-3 pl-4 pr-10 border-gray-200 rounded-xl text-gray-700 focus:ring-2 focus:ring-brand-500 focus:border-transparent bg-gray-50 focus:bg-white cursor-pointer">
                                <option value="">All Years</option>
                                <?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $yearOption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($yearOption); ?>" <?php echo e(request('year') == $yearOption ? 'selected' : ''); ?>>
                                        <?php echo e($yearOption); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <!-- Country Filter -->
                        <div class="min-w-[160px]">
                            <select name="country"
                                class="block w-full py-3 pl-4 pr-10 border-gray-200 rounded-xl text-gray-700 focus:ring-2 focus:ring-brand-500 focus:border-transparent bg-gray-50 focus:bg-white cursor-pointer">
                                <option value="">All Countries</option>
                                <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $countryOption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($countryOption); ?>" <?php echo e(request('country') == $countryOption ? 'selected' : ''); ?>>
                                        <?php echo e($countryOption); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <!-- Submit Button -->
                        <button type="submit"
                            class="bg-brand-600 text-white px-8 py-3 rounded-xl font-semibold hover:bg-brand-500 transition-all shadow-lg hover:shadow-brand-500/30 active:scale-95 whitespace-nowrap flex items-center justify-center gap-2">
                            <span>Filter</span>
                            <i class="fas fa-filter text-sm"></i>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Conferences Grid -->
    <div class="bg-gray-50 py-12 sm:py-12" x-data="{ layoutMode: 'grid' }">
        <div class="mx-auto max-w-7xl px-6 lg:px-8">

            <!-- View Toggle & Results Count -->
            <div
                class="flex flex-col sm:flex-row justify-between items-center mb-8 pb-4 border-b border-gray-200 gap-4">
                <span class="text-gray-500 font-medium"><?php echo e($conferences->total()); ?> events found</span>

                <div class="flex items-center gap-2 p-1 bg-white rounded-lg border border-gray-200 shadow-sm">
                    <button type="button" x-on:click.stop="layoutMode = 'grid'"
                        :class="{ 'bg-brand-50 text-brand-600': layoutMode === 'grid', 'text-gray-400 hover:text-gray-600': layoutMode !== 'grid' }"
                        class="p-2 rounded-md transition-all duration-200 cursor-pointer">
                        <i class="fas fa-th-large text-lg"></i>
                    </button>
                    <button type="button" x-on:click.stop="layoutMode = 'list'"
                        :class="{ 'bg-brand-50 text-brand-600': layoutMode === 'list', 'text-gray-400 hover:text-gray-600': layoutMode !== 'list' }"
                        class="p-2 rounded-md transition-all duration-200 cursor-pointer">
                        <i class="fas fa-bars text-lg"></i>
                    </button>
                </div>
            </div>

            <?php /** @var \Illuminate\Pagination\LengthAwarePaginator $conferences */ ?>

            <!-- Grid View (Modern Cards) -->
            <div x-show="layoutMode === 'grid'"
                class="grid grid-cols-1 gap-x-6 gap-y-10 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4">
                <?php $__currentLoopData = $conferences; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $conference): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <article
                        class="flex flex-col bg-white rounded-2xl shadow-sm hover:shadow-xl transition-all duration-300 overflow-hidden group border border-gray-100 hover:-translate-y-1">
                        <!-- Image Container -->
                        <div class="relative overflow-hidden w-full aspect-[4/3] bg-gray-200">
                            <img src="<?php echo e($conference['image']); ?>" alt="<?php echo e($conference['title']); ?>" loading="lazy"
                                class="absolute inset-0 w-full h-full object-cover group-hover:scale-105 transition-transform duration-700">

                            <!-- Date Badge -->
                            <div
                                class="absolute top-4 left-4 bg-white/95 backdrop-blur-md px-4 py-2 rounded-xl text-center shadow-lg border border-white/20">
                                <span
                                    class="block text-xs font-bold text-gray-400 uppercase tracking-wider"><?php echo e(explode(' ', $conference['formatted_date'])[1]); ?></span>
                                <span
                                    class="block text-xl font-bold text-brand-600 leading-none"><?php echo e(explode(' ', $conference['formatted_date'])[0]); ?></span>
                            </div>

                            <?php if(isset($conference['category'])): ?>
                                <div class="absolute top-4 right-4">
                                    <span
                                        class="px-3 py-1 rounded-full text-xs font-bold text-white shadow-sm backdrop-blur-md
                                                                                                                                    <?php if($conference['category'] === 'Technology'): ?> bg-blue-500/90
                                                                                                                                    <?php elseif($conference['category'] === 'Environment'): ?> bg-green-500/90
                                                                                                                                    <?php elseif($conference['category'] === 'Business'): ?> bg-purple-500/90
                                                                                                                                    <?php elseif($conference['category'] === 'Health'): ?> bg-red-500/90
                                                                                                                                    <?php elseif($conference['category'] === 'Science'): ?> bg-indigo-500/90
                                                                                                                                    <?php else: ?> bg-gray-500/90 <?php endif; ?>">
                                        <?php echo e($conference['category']); ?>

                                    </span>
                                </div>
                            <?php endif; ?>
                        </div>

                        <div class="p-6 flex flex-col flex-grow">
                            <div class="flex items-center gap-x-2 text-xs mb-3">
                                <span
                                    class="rounded-full bg-brand-50 px-2.5 py-1 font-medium text-brand-600 flex items-center gap-1">
                                    <i class="fas fa-map-marker-alt"></i> <?php echo e($conference['location']); ?>

                                </span>
                            </div>

                            <h3 class="text-base font-bold leading-snug text-gray-900 group-hover:text-brand-600 transition-colors mb-2 line-clamp-2"
                                title="<?php echo e($conference['title']); ?>">
                                <a href="<?php echo e(route('conference.show', $conference['slug'])); ?>" target="_blank">
                                    <span class="absolute inset-0"></span>
                                    <?php echo e($conference['title']); ?>

                                </a>
                            </h3>

                            <div class="pt-4 border-t border-gray-100 flex items-center justify-between mt-auto">
                                <div class="flex flex-col gap-1 text-sm font-medium text-gray-500">
                                    <div class="flex items-center gap-2">
                                        <i class="far fa-calendar-alt text-brand-400"></i>
                                        <?php echo e($conference['date']); ?>

                                    </div>
                                    <div class="flex items-center gap-2 text-xs text-brand-600">
                                        <i class="far fa-clock"></i>
                                        <span>Deadline: <?php echo e($conference['deadline']); ?></span>
                                    </div>
                                </div>
                                <span
                                    class="text-brand-600 text-sm font-bold flex items-center gap-1 group-hover:translate-x-1 transition-transform">
                                    Details <i class="fas fa-arrow-right text-xs"></i>
                                </span>
                            </div>
                        </div>
                    </article>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- List View (Creative Row Style) -->
            <div x-show="layoutMode === 'list'" class="flex flex-col gap-3">
                <?php $__currentLoopData = $conferences; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $conference): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <article
                        class="bg-white rounded-lg p-3 shadow-sm border border-gray-100 hover:shadow-md transition-all group flex flex-col sm:flex-row gap-4 items-center">
                        <!-- Date Box -->
                        <div
                            class="flex-shrink-0 flex flex-col items-center justify-center w-14 h-14 bg-brand-50 rounded-xl border border-brand-100 group-hover:bg-brand-600 transition-colors duration-300">
                            <span
                                class="text-xs font-bold text-brand-600 uppercase tracking-wider group-hover:text-brand-100"><?php echo e(explode(' ', $conference['formatted_date'])[1]); ?></span>
                            <span
                                class="text-lg font-black text-brand-700 leading-none group-hover:text-white"><?php echo e(explode(' ', $conference['formatted_date'])[0]); ?></span>
                        </div>

                        <!-- Content -->
                        <div class="flex-grow min-w-0 flex flex-col sm:flex-row sm:items-center gap-2 sm:gap-4">
                            <div class="flex-grow">
                                <h3 class="text-sm font-bold text-gray-900 group-hover:text-brand-600 transition-colors mb-1 leading-snug truncate"
                                    title="<?php echo e($conference['title']); ?>">
                                    <a href="<?php echo e(route('conference.show', $conference['slug'])); ?>" target="_blank"
                                        class="focus:outline-none">
                                        <span class="absolute inset-0 sm:static"></span>
                                        <?php echo e($conference['title']); ?>

                                    </a>
                                </h3>

                                <div class="flex items-center gap-3 text-xs text-gray-500">
                                    <div class="flex items-center gap-1">
                                        <i class="fas fa-map-marker-alt text-gray-400"></i>
                                        <span><?php echo e($conference['location']); ?></span>
                                    </div>
                                    <div class="flex items-center gap-1 text-orange-600 bg-orange-50 px-1.5 py-0.5 rounded">
                                        <i class="far fa-clock text-[10px]"></i>
                                        <span class="font-medium">Deadline: <?php echo e($conference['deadline']); ?></span>
                                    </div>
                                    <?php if(isset($conference['category'])): ?>
                                        <span
                                            class="rounded-full px-2 py-0.5 text-[10px] font-semibold text-white
                                                                                                            <?php if($conference['category'] === 'Technology'): ?> bg-blue-500
                                                                                                            <?php elseif($conference['category'] === 'Environment'): ?> bg-green-500
                                                                                                            <?php else: ?> bg-gray-500 <?php endif; ?>">
                                            <?php echo e($conference['category']); ?>

                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <!-- Action -->
                            <div class="flex-shrink-0 self-end sm:self-center">
                                <a href="<?php echo e(route('conference.show', $conference['slug'])); ?>" target="_blank"
                                    class="inline-flex items-center justify-center px-4 py-1.5 border border-transparent text-xs font-semibold rounded-lg text-brand-600 bg-brand-50 hover:bg-brand-100 transition-colors group-hover:bg-brand-600 group-hover:text-white whitespace-nowrap">
                                    View Details
                                </a>
                            </div>
                        </div>
                    </article>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Empty State -->
            <?php if($conferences->count() === 0): ?>
                <div class="text-center py-20">
                    <div class="bg-gray-100 rounded-full h-20 w-20 flex items-center justify-center mx-auto mb-6">
                        <i class="fas fa-search text-gray-400 text-3xl"></i>
                    </div>
                    <h3 class="text-lg font-bold text-gray-900 mb-2">No conferences found</h3>
                    <p class="text-gray-500 max-w-sm mx-auto mb-8">We couldn't find any events matching your criteria. Try
                        adjusting your filters.</p>
                    <a href="<?php echo e(route('upcoming-conferences')); ?>"
                        class="text-brand-600 font-semibold hover:text-brand-700">Clear all filters</a>
                </div>
            <?php endif; ?>

            <!-- Pagination -->
            <?php if($conferences->hasPages()): ?>
                <div class="mt-16">
                    <?php echo e($conferences->withQueryString()->links('pagination::tailwind')); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Newsletter Section -->
    <div class="bg-white py-16 sm:py-24">
        <div class="mx-auto max-w-7xl sm:px-6 lg:px-8">
            <div class="relative isolate overflow-hidden bg-slate-900 px-6 py-24 shadow-2xl sm:rounded-3xl sm:px-24">
                <h2 class="mx-auto max-w-2xl text-center text-3xl font-bold tracking-tight text-white sm:text-4xl">Get
                    notified about new events</h2>
                <p class="mx-auto mt-2 max-w-xl text-center text-lg leading-8 text-gray-300">
                    Subscribe to our newsletter to receive updates on call for papers, registration deadlines, and
                    speaker announcements.
                </p>
                <form class="mx-auto mt-10 flex max-w-md gap-x-4">
                    <label for="email-address" class="sr-only">Email address</label>
                    <input id="email-address" name="email" type="email" autocomplete="email" required
                        class="min-w-0 flex-auto rounded-md border-0 bg-white/5 px-3.5 py-2 text-white shadow-sm ring-1 ring-inset ring-white/10 focus:ring-2 focus:ring-inset focus:ring-brand-500 sm:text-sm sm:leading-6 placeholder:text-gray-400"
                        placeholder="Enter your email">
                    <button type="submit"
                        class="flex-none rounded-md bg-brand-600 px-3.5 py-2.5 text-sm font-semibold text-white shadow-sm hover:bg-brand-500 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-brand-500 hover:scale-105 transition-transform">Subscribe</button>
                </form>
                <svg viewBox="0 0 1024 1024"
                    class="absolute left-1/2 top-1/2 -z-10 h-[64rem] w-[64rem] -translate-x-1/2 [mask-image:radial-gradient(closest-side,white,transparent)]"
                    aria-hidden="true">
                    <circle cx="512" cy="512" r="512" fill="url(#gradient)" fill-opacity="0.25" />
                    <defs>
                        <radialGradient id="gradient">
                            <stop stop-color="#3B82F6" />
                            <stop offset="1" stop-color="#1E293B" />
                        </radialGradient>
                    </defs>
                </svg>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal66d7cfd03cd343304d81fe1e21646540)): ?>
<?php $attributes = $__attributesOriginal66d7cfd03cd343304d81fe1e21646540; ?>
<?php unset($__attributesOriginal66d7cfd03cd343304d81fe1e21646540); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal66d7cfd03cd343304d81fe1e21646540)): ?>
<?php $component = $__componentOriginal66d7cfd03cd343304d81fe1e21646540; ?>
<?php unset($__componentOriginal66d7cfd03cd343304d81fe1e21646540); ?>
<?php endif; ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/ecom/resources/views/upcoming-conferences.blade.php ENDPATH**/ ?>