<?php if (isset($component)) { $__componentOriginal4ded15da7e279fded52d1c5c94436b4a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4ded15da7e279fded52d1c5c94436b4a = $attributes; } ?>
<?php $component = App\View\Components\ConferenceLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('conference-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ConferenceLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('title', null, []); ?> <?php echo e($conference['title']); ?> <?php $__env->endSlot(); ?>

    <!-- Hero Section -->
    <section id="home"
        class="relative h-screen min-h-[800px] flex items-center justify-center text-white overflow-hidden bg-black">
        <!-- Background Image with Overlay -->
        <div class="absolute inset-0 z-0">
            <img src="<?php echo e($conference['image']); ?>" alt="Conference Venue" class="w-full h-full object-cover opacity-60">
            <!-- Complex Gradient Overlay for "Premium" feel -->
            <div class="absolute inset-0 bg-gradient-to-b from-black/80 via-transparent to-black"></div>
            <div class="absolute inset-0 bg-gradient-to-r from-black/50 via-transparent to-black/50"></div>
        </div>

        <div class="relative z-10 max-w-7xl mx-auto px-4 text-center mt-[-100px]">
            <!-- Dynamic Content based on Title -->
            <?php if(isset($conference['prefix'])): ?>
                <span class="block text-brand-200 text-lg md:text-xl font-bold tracking-widest uppercase mb-4"><?php echo e($conference['prefix']); ?></span>
            <?php else: ?>
                <span class="block text-brand-200 text-lg md:text-xl font-bold tracking-widest uppercase mb-4"><?php echo e($conference['date']); ?></span>
            <?php endif; ?>

            <h1 class="flex flex-col items-center justify-center leading-none tracking-tighter mb-8 select-none">
                <span
                    class="text-4xl md:text-6xl lg:text-7xl font-bold text-transparent bg-clip-text bg-gradient-to-b from-white to-gray-400 opacity-90 filter drop-shadow-2xl text-center">
                    <?php echo e(strtoupper($conference['title'])); ?>

                </span>
            </h1>

            <p class="text-lg md:text-xl text-gray-300 font-light tracking-wide max-w-4xl mx-auto mb-12">
                <?php echo e($conference['subtitle'] ?? 'We are shaping the future.'); ?>

            </p>
        </div>

        <!-- Stats / Countdown Bar (Floating) -->
        <div class="absolute bottom-10 left-4 right-4 z-20">
            <div
                class="max-w-6xl mx-auto bg-white rounded-xl shadow-2xl p-4 md:px-8 md:py-6 flex flex-col md:flex-row items-center justify-between gap-6 relative">

                <!-- Sales Text -->
                <div class="text-center md:text-left">
                    <p class="text-gray-600 font-medium">Save 50% on your ticket.</p>
                    <p class="text-gray-500 text-sm">Our 2 for 1 sale ends in</p>
                </div>

                <!-- Countdown -->
                <div class="flex items-center gap-8 md:gap-12" x-data="{
                        days: '00', hours: '00', minutes: '00', seconds: '00',
                        deadline: new Date('<?php echo e($conference['deadline'] ?? '2026-12-31'); ?>').getTime(),
                        init() {
                            this.updateTimer();
                            setInterval(() => this.updateTimer(), 1000);
                        },
                        updateTimer() {
                            const now = new Date().getTime();
                            const t = this.deadline - now;
                            if (t > 0) {
                                this.days = Math.floor(t / (1000 * 60 * 60 * 24)).toString().padStart(2, '0');
                                this.hours = Math.floor((t % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60)).toString().padStart(2, '0');
                                this.minutes = Math.floor((t % (1000 * 60 * 60)) / (1000 * 60)).toString().padStart(2, '0');
                                this.seconds = Math.floor((t % (1000 * 60)) / 1000).toString().padStart(2, '0');
                            }
                        }
                    }">
                    <div class="text-center">
                        <span class="block text-3xl md:text-4xl font-bold text-gray-800" x-text="days">00</span>
                        <span class="text-xs text-gray-500 uppercase tracking-wide">Days</span>
                    </div>
                    <div class="text-center">
                        <span class="block text-3xl md:text-4xl font-bold text-gray-800" x-text="hours">00</span>
                        <span class="text-xs text-gray-500 uppercase tracking-wide">Hours</span>
                    </div>
                    <div class="text-center">
                        <span class="block text-3xl md:text-4xl font-bold text-gray-800" x-text="minutes">00</span>
                        <span class="text-xs text-gray-500 uppercase tracking-wide">Minutes</span>
                    </div>
                    <div class="text-center">
                        <span class="block text-3xl md:text-4xl font-bold text-gray-800" x-text="seconds">00</span>
                        <span class="text-xs text-gray-500 uppercase tracking-wide">Seconds</span>
                    </div>
                </div>

                <!-- CTA Button -->
                <div>
                    <a href="#tickets"
                        class="inline-flex h-12 items-center justify-center px-8 bg-gray-800 text-white font-bold text-sm hover:bg-black transition-all rounded-md shadow-lg">
                        Buy tickets
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Call for Papers & Scope & Dates -->
    <section class="py-24 bg-gray-50 border-b border-gray-200 relative">
        <div class="max-w-7xl mx-auto px-6 lg:px-8">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-16">

                <!-- Left: Call for Papers -->
                <div class="lg:col-span-2">
                    <span
                        class="text-orange-600 font-bold tracking-widest uppercase text-xs mb-2 block">Opportunity</span>
                    <h2 class="text-4xl font-bold text-gray-900 font-serif mb-8">Call for Papers</h2>

                    <?php if(isset($conference['call_for_papers'])): ?>
                        <div class="prose prose-lg text-gray-600 mb-10 leading-relaxed">
                            <p><?php echo e($conference['call_for_papers']['text']); ?></p>
                        </div>
                    <?php endif; ?>

                    <!-- Scopes Grid -->
                    <?php if(isset($conference['scopes'])): ?>
                        <div class="bg-gray-50 rounded-2xl p-8 border border-gray-100">
                            <h3 class="text-xl font-bold text-gray-900 mb-6 flex items-center gap-2">
                                <i class="fas fa-bullseye text-orange-500"></i> Conference Scope
                            </h3>
                            <div class="space-y-8">
                                <?php $__currentLoopData = $conference['scopes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category => $subScopes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div>
                                        <h4 class="font-bold text-gray-800 mb-3 border-l-4 border-orange-500 pl-3">
                                            <?php echo e($category); ?></h4>
                                        <div class="grid grid-cols-1 md:grid-cols-2 gap-2 ml-4">
                                            <?php if(is_array($subScopes)): ?>
                                                <?php $__currentLoopData = $subScopes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $scope): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="flex items-start gap-2">
                                                        <i class="fas fa-angle-right text-gray-400 mt-1 text-xs"></i>
                                                        <span
                                                            class="text-gray-600 text-sm hover:text-orange-600 transition-colors cursor-default"><?php echo e($scope); ?></span>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php else: ?>
                                                <div class="flex items-start gap-2">
                                                    <i class="fas fa-angle-right text-gray-400 mt-1 text-xs"></i>
                                                    <span class="text-gray-600 text-sm"><?php echo e($subScopes); ?></span>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Right: Important Dates -->
                <div class="lg:col-span-1">
                    <?php if(isset($conference['important_dates'])): ?>
                        <div class="bg-gray-900 text-white rounded-2xl p-8 shadow-2xl relative overflow-hidden">
                            <div
                                class="absolute top-0 right-0 w-32 h-32 bg-orange-500/20 rounded-full blur-3xl -mr-10 -mt-10">
                            </div>

                            <h3 class="text-2xl font-bold font-serif mb-8 border-b border-gray-700 pb-4">Important Dates
                            </h3>

                            <div class="space-y-6">
                                <?php $__currentLoopData = $conference['important_dates']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="group">
                                        <p
                                            class="text-xs text-gray-400 font-bold uppercase tracking-wider mb-1 group-hover:text-orange-400 transition-colors">
                                            <?php echo e($date['label']); ?>

                                        </p>
                                        <p class="text-lg font-bold text-white"><?php echo e($date['date']); ?></p>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            <a href="#register"
                                class="mt-10 w-full block py-4 bg-orange-600 hover:bg-orange-700 text-white font-bold text-center rounded-lg transition-all shadow-lg hover:shadow-orange-500/20">
                                Submit Abstract
                            </a>
                        </div>
                    <?php endif; ?>
                </div>

            </div>
        </div>
    </section>

    <!-- Speakers Section (White) -->
    <section id="speakers" class="py-32 bg-white relative">
        <div class="max-w-7xl mx-auto px-6 lg:px-8">
            <div class="flex flex-col md:flex-row justify-between items-end mb-16">
                <div>
                    <span class="text-orange-600 font-bold tracking-widest uppercase text-xs mb-2 block">World
                        Class</span>
                    <h2 class="text-4xl md:text-5xl font-bold text-gray-900 font-serif">Amazing Line-up <br>Speakers
                    </h2>
                </div>
                <div class="hidden md:block">
                    <a href="#"
                        class="text-gray-900 font-bold border-b-2 border-gray-900 hover:text-orange-600 hover:border-orange-600 transition-colors pb-1">View
                        All Speakers</a>
                </div>
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8">
                <?php if(isset($conference['speakers'])): ?>
                    <?php $__currentLoopData = $conference['speakers']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $speaker): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="group cursor-pointer">
                            <div class="relative overflow-hidden mb-4 rounded-sm bg-gray-100 aspect-[3/4]">
                                <img src="<?php echo e($speaker['image']); ?>" alt="<?php echo e($speaker['name']); ?>"
                                    class="w-full h-full object-cover transition-transform duration-700 group-hover:scale-105 filter grayscale group-hover:grayscale-0">

                                <div
                                    class="absolute bottom-0 left-0 w-full p-4 bg-gradient-to-t from-black/80 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300 translate-y-2 group-hover:translate-y-0">
                                    <div class="flex space-x-3 text-white">
                                        <i class="fab fa-linkedin text-lg hover:text-orange-400"></i>
                                        <i class="fab fa-twitter text-lg hover:text-orange-400"></i>
                                    </div>
                                </div>
                            </div>
                            <h3 class="text-xl font-bold text-gray-900 group-hover:text-orange-600 transition-colors">
                                <?php echo e($speaker['name']); ?>

                            </h3>
                            <p class="text-sm text-gray-500 font-medium"><?php echo e($speaker['role']); ?></p>
                            <p class="text-xs text-gray-400 uppercase tracking-wide mt-1"><?php echo e($speaker['company']); ?></p>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <!-- Fallback if no speakers data -->
                    <div class="col-span-4 text-center text-gray-500">Speakers to be announced.</div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <!-- Schedule / Timeline Section (Dark with Gradient) -->
    <section id="schedule" class="py-32 bg-gray-900 relative overflow-hidden">
        <!-- Ambient Background -->
        <div class="absolute inset-0 bg-gradient-to-br from-gray-900 via-gray-900 to-black"></div>
        <div
            class="absolute top-0 right-0 w-[500px] h-[500px] bg-orange-600/20 rounded-full blur-[100px] pointer-events-none">
        </div>
        <div
            class="absolute bottom-0 left-0 w-[500px] h-[500px] bg-blue-600/10 rounded-full blur-[100px] pointer-events-none">
        </div>

        <div class="max-w-7xl mx-auto px-6 lg:px-8 relative z-10">
            <div class="mb-20">
                <span class="text-orange-500 font-bold tracking-widest uppercase text-xs mb-2 block">Agenda</span>
                <h2 class="text-4xl md:text-6xl font-bold text-white font-serif max-w-2xl">
                    Follow the timeline so you won't <span class="italic text-gray-400">miss anything.</span>
                </h2>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-16">
                <!-- Day 01 -->
                <?php if(isset($conference['schedule'])): ?>
                    <?php $__currentLoopData = $conference['schedule']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date => $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div>
                            <div class="flex items-baseline justify-between border-b border-gray-800 pb-4 mb-8">
                                <h3 class="text-3xl font-bold text-white">
                                    <?php echo e(explode('/', $date)[0]); ?>/<?php echo e(explode('/', $date)[1]); ?><span
                                        class="text-lg text-gray-500 font-normal">/2026</span>
                                </h3>
                                <span class="text-orange-500 font-medium"><?php echo e($day['title'] ?? 'Conference Day'); ?></span>
                            </div>

                            <div class="space-y-8">
                                <?php $__currentLoopData = $day['events']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="group">
                                        <div class="flex gap-6 items-start">
                                            <div class="w-24 flex-shrink-0 pt-1">
                                                <span
                                                    class="text-sm font-bold text-white bg-white/10 px-2 py-1 rounded group-hover:bg-orange-500 transition-colors"><?php echo e($event['time']); ?></span>
                                            </div>
                                            <div>
                                                <h4
                                                    class="text-xl font-bold text-white mb-1 group-hover:text-orange-400 transition-colors">
                                                    <?php echo e($event['title']); ?>

                                                </h4>
                                                <p class="text-gray-400 text-sm">by <span
                                                        class="text-white"><?php echo e($event['speaker']); ?></span></p>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
        </div>

        <!-- Scrolling Text Background -->
        <div class="absolute bottom-10 left-0 w-full overflow-hidden opacity-5 pointer-events-none">
            <div class="whitespace-nowrap text-[150px] font-black text-white leading-none">
                KEYNOTES WORKSHOPS NETWORKING FUTURE
            </div>
        </div>
    </section>

    <!-- Registration & Fees Section (Dark Premium) -->
    <section id="tickets" class="py-32 bg-black text-white relative" x-data="{ type: 'international' }">
        <div class="absolute inset-0 bg-[url('https://www.transparenttextures.com/patterns/cubes.png')] opacity-10">
        </div>
        <div
            class="absolute top-0 right-0 w-[600px] h-[600px] bg-indigo-900/20 rounded-full blur-[120px] pointer-events-none">
        </div>

        <div class="max-w-7xl mx-auto px-6 lg:px-8 relative z-10">
            <div class="mb-16 text-center">
                <span class="text-orange-500 font-bold tracking-widest uppercase text-xs mb-2 block">Registration</span>
                <h2 class="text-4xl md:text-6xl font-bold mb-6 font-serif">Registration Fees</h2>
                <p class="text-gray-400 max-w-2xl mx-auto text-lg">Detailed breakdown of participation categories.
                    Choose the plan that suits you best.</p>

                <!-- Tabs -->
                <div class="flex justify-center mt-10">
                    <div class="bg-white/5 p-1 rounded-full inline-flex border border-white/10">
                        <button @click="type = 'international'"
                            :class="{ 'bg-orange-600 text-white shadow-lg': type === 'international', 'text-gray-400 hover:text-white': type !== 'international' }"
                            class="px-8 py-3 rounded-full font-bold text-sm tracking-wide transition-all duration-300">
                            International
                        </button>
                        <button @click="type = 'domestic'"
                            :class="{ 'bg-orange-600 text-white shadow-lg': type === 'domestic', 'text-gray-400 hover:text-white': type !== 'domestic' }"
                            class="px-8 py-3 rounded-full font-bold text-sm tracking-wide transition-all duration-300">
                            Domestic
                        </button>
                    </div>
                </div>
            </div>

            <!-- Pricing Grid -->
            <div class="grid gap-6">
                <!-- International Pricing -->
                <div x-show="type === 'international'" x-transition:enter="transition ease-out duration-300 transform"
                    x-transition:enter-start="opacity-0 scale-95" x-transition:enter-end="opacity-100 scale-100"
                    class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-4 gap-6">
                    <?php if(isset($conference['registration']['international']['categories'])): ?>
                        <?php $__currentLoopData = $conference['registration']['international']['categories']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div
                                class="relative group p-8 rounded-2xl border border-white/10 bg-white/5 hover:bg-white/10 transition-all duration-300 flex flex-col h-full hover:-translate-y-2">
                                <div
                                    class="absolute inset-0 bg-gradient-to-b from-orange-500/0 to-orange-500/5 opacity-0 group-hover:opacity-100 transition-opacity duration-500 rounded-2xl">
                                </div>

                                <h3
                                    class="text-xl font-bold mb-2 text-white group-hover:text-orange-500 transition-colors py-2 min-h-[70px] flex items-center">
                                    <?php echo e($category['name']); ?>

                                </h3>
                                <p class="text-xs text-gray-500 font-medium uppercase tracking-wider mb-6">
                                    <?php echo e($category['description']); ?>

                                </p>

                                <div class="space-y-4 mb-8 flex-grow">
                                    <div class="flex justify-between items-end border-b border-dashed border-gray-700 pb-2">
                                        <span class="text-gray-400 text-sm">Early Bird</span>
                                        <span
                                            class="text-2xl font-bold text-white"><?php echo e($conference['registration']['international']['currency']); ?>

                                            <?php echo e($category['early_bird']); ?></span>
                                    </div>
                                    <div class="flex justify-between items-end">
                                        <span class="text-gray-400 text-sm">Regular</span>
                                        <span
                                            class="text-xl font-bold text-gray-300"><?php echo e($conference['registration']['international']['currency']); ?>

                                            <?php echo e($category['regular']); ?></span>
                                    </div>
                                </div>

                                <div class="space-y-3 mb-8">
                                    <?php $__currentLoopData = $category['benefits']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $benefit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="flex items-start gap-3">
                                            <i class="fas fa-check-circle text-orange-600 mt-1 text-xs"></i>
                                            <span class="text-sm text-gray-400 leading-snug"><?php echo e($benefit); ?></span>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>

                                <a href="#register"
                                    class="w-full py-3 text-center rounded-lg bg-white text-black font-bold uppercase text-xs tracking-widest hover:bg-orange-600 hover:text-white transition-all duration-300 shadow-lg mt-auto">
                                    Register Now
                                </a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <div class="col-span-4 text-center text-gray-400 py-10">Registration details coming soon.</div>
                    <?php endif; ?>
                </div>

                <!-- Domestic Pricing -->
                <div x-show="type === 'domestic'" x-transition:enter="transition ease-out duration-300 transform"
                    x-transition:enter-start="opacity-0 scale-95" x-transition:enter-end="opacity-100 scale-100"
                    class="grid grid-cols-1 md:grid-cols-3 gap-6" style="display: none;">
                    <?php if(isset($conference['registration']['domestic']['categories'])): ?>
                        <?php $__currentLoopData = $conference['registration']['domestic']['categories']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div
                                class="relative group p-8 rounded-2xl border border-white/10 bg-white/5 hover:bg-white/10 transition-all duration-300 flex flex-col h-full hover:-translate-y-2">
                                <h3 class="text-xl font-bold mb-2 text-white group-hover:text-green-500 transition-colors py-2">
                                    <?php echo e($category['name']); ?>

                                </h3>
                                <p class="text-xs text-gray-500 font-medium uppercase tracking-wider mb-6">
                                    <?php echo e($category['description']); ?>

                                </p>

                                <div class="space-y-4 mb-8 flex-grow">
                                    <div class="flex justify-between items-end border-b border-dashed border-gray-700 pb-2">
                                        <span class="text-gray-400 text-sm">Early Bird</span>
                                        <span
                                            class="text-2xl font-bold text-white"><?php echo e($conference['registration']['domestic']['currency']); ?>

                                            <?php echo e($category['early_bird']); ?></span>
                                    </div>
                                    <div class="flex justify-between items-end">
                                        <span class="text-gray-400 text-sm">Regular</span>
                                        <span
                                            class="text-xl font-bold text-gray-300"><?php echo e($conference['registration']['domestic']['currency']); ?>

                                            <?php echo e($category['regular']); ?></span>
                                    </div>
                                </div>

                                <div class="space-y-3 mb-8">
                                    <?php $__currentLoopData = $category['benefits']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $benefit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="flex items-start gap-3">
                                            <i class="fas fa-check-circle text-green-600 mt-1 text-xs"></i>
                                            <span class="text-sm text-gray-400 leading-snug"><?php echo e($benefit); ?></span>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>

                                <a href="#register"
                                    class="w-full py-3 text-center rounded-lg bg-white text-black font-bold uppercase text-xs tracking-widest hover:bg-green-600 hover:text-white transition-all duration-300 shadow-lg mt-auto">
                                    Register Local
                                </a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <div class="col-span-3 text-center text-gray-400 py-10">Domestic rates unavailable.</div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Additional Info -->
            <div
                class="mt-16 grid grid-cols-1 md:grid-cols-2 gap-8 text-sm text-gray-400 bg-white/5 p-8 rounded-xl border border-white/10">
                <div>
                    <h4 class="text-white font-bold mb-2 uppercase tracking-wider">Registration Covers</h4>
                    <p>Admission to all scientific sessions, Conference Materials, Certificate of Attendance, Lunch and
                        Coffee breaks during the conference days.</p>
                </div>
                <div>
                    <h4 class="text-white font-bold mb-2 uppercase tracking-wider">Cancellation Policy</h4>
                    <p>Cancellations must be received in writing. 50% refund before 30 days of the conference. No
                        refunds within 30 days.</p>
                </div>
            </div>
        </div>
    </section>



 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4ded15da7e279fded52d1c5c94436b4a)): ?>
<?php $attributes = $__attributesOriginal4ded15da7e279fded52d1c5c94436b4a; ?>
<?php unset($__attributesOriginal4ded15da7e279fded52d1c5c94436b4a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4ded15da7e279fded52d1c5c94436b4a)): ?>
<?php $component = $__componentOriginal4ded15da7e279fded52d1c5c94436b4a; ?>
<?php unset($__componentOriginal4ded15da7e279fded52d1c5c94436b4a); ?>
<?php endif; ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/ecom/resources/views/conference/home.blade.php ENDPATH**/ ?>