<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ProductSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        \Illuminate\Support\Facades\DB::table('products')->insert([
            [
                'name' => 'Laptop',
                'description' => 'High performance laptop for developers.',
                'price' => 1200.00,
                'image_url' => 'https://via.placeholder.com/300?text=Laptop',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Phone',
                'description' => 'Latest smartphone with great camera.',
                'price' => 800.00,
                'image_url' => 'https://via.placeholder.com/300?text=Phone',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Watch',
                'description' => 'Smart watch to track your fitness.',
                'price' => 250.00,
                'image_url' => 'https://via.placeholder.com/300?text=Watch',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Headset',
                'description' => 'Noise cancelling headset for music lovers.',
                'price' => 150.00,
                'image_url' => 'https://via.placeholder.com/300?text=Headset',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }
}
